/**
 * 
 */
package gov.va.med.mhv.usermgmt.web.controller;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.web.formbean.ChangePassword;

import java.io.IOException;
import java.io.Serializable;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
/**
 * @author PII
 * 
 */
@ManagedBean
@Component
@Scope(WebApplicationContext.SCOPE_REQUEST)
public class ChangePasswordController extends AbstractController implements
		Serializable {

	private static final long serialVersionUID = -9191875686222494443L;

	static Log logger = LogFactoryUtil
			.getLog(ChangePasswordController.class);

	@Autowired
	private ChangePassword changePassword;

	private String successMessage = null;

	public ChangePassword getChangePassword() {
		return changePassword;
	}

	public String getSuccessMessage() {
		return successMessage;
	}

	public void authorize() throws IOException {

		logger.info("========inside authorize()============ ");

		PortletRequest request = (PortletRequest) FacesContext
				.getCurrentInstance().getExternalContext().getRequest();

		if (request.getUserPrincipal() == null) {
			FacesContext context = FacesContext.getCurrentInstance();
			context.getApplication().getNavigationHandler()
					.handleNavigation(context, null, "uanuthorized.xhtml");
		} else {
			PortletSession session = request.getPortletSession();
			String userid = (String) session.getAttribute(
					"LIFERAY_SHARED_userid", PortletSession.APPLICATION_SCOPE);

			// TODO: add a method to get userId/Password
			//getUserProfile(userid);
		}
	}

	public String updatePassword() {
		FacesContext context = FacesContext.getCurrentInstance();

		logger.info("========inside updatePassword()============ ");

		PortletRequest request = (PortletRequest) FacesContext
				.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();

		logger.debug("EmergencyContactListController - loadModel");

		logger.debug("EmergencyContactListController - Gson created");
		String userid = (String) session.getAttribute("LIFERAY_SHARED_userid",
				PortletSession.APPLICATION_SCOPE);
		UserProfileDTO userProfile = getUserProfile(userid);
		userProfile.setPassword(this.changePassword.getNewPassword());


		userProfile.setConfPassword(this.changePassword.getConfirmNewPassword());
		userProfile.setOldPassword(this.changePassword.getCurrentPassword());
		validatePassword(userProfile,true);
		
		if( FacesContext.getCurrentInstance().getMessageList().size() > 0 ) {
			
			context.getApplication().getNavigationHandler().
	        handleNavigation(context, null, "/views/account/changePassword.xhtml");
			return null;
		}
		

		try {
			// /userpassword/changepassword
			logger.debug("ChangePasswordController - saveContactAction - get WebClient");
			
			this.userMgmtService.changePassword(userProfile,Boolean.FALSE);
			
			logger.debug("ChangePasswordController - saveContactAction - success");
			this.successMessage = "success";
			FacesContext.getCurrentInstance().addMessage(
				null, new FacesMessage(FacesMessage.SEVERITY_INFO, 
				"Your password has been changed succesfully.", "SUCCESS"));
		} catch (MHVException e) {
			super.processErrorMessages(e);
			return null;
		} catch (Exception e) {
			this.successMessage = "failure";
			logger.debug("ChangePasswordController - saveContactAction - fail");
			logger.debug("ChangePasswordController - exception "
					+ e.getMessage());
			
			logger.error(e);
			
		}

		logger.info("successMessage : " + successMessage);

		context.getApplication().getNavigationHandler().
        handleNavigation(context, null, "/views/account/changePassword.xhtml");
		
		return null;
	}

}